﻿Imports Microsoft.Devices.Sensors

Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Public Sub New()
        InitializeComponent()

        Dim acc As New Accelerometer()
        AddHandler acc.ReadingChanged, AddressOf OnAccelerometerReadingChanged

        Try
            acc.Start()
        Catch exc As Exception
            txtblk.Text = exc.Message
        End Try
    End Sub


    Private Sub OnAccelerometerReadingChanged(ByVal sender As Object,
                                              ByVal args As AccelerometerReadingEventArgs)
        Dim str = String.Format("X = {0:F2}" & System.Environment.NewLine &
                                "Y = {1:F2}" & System.Environment.NewLine &
                                "Z = {2:F2}" &
                                System.Environment.NewLine & System.Environment.NewLine &
                                "Magnitude = {3:F2}" &
                                System.Environment.NewLine & System.Environment.NewLine &
                                "{4}",
                                args.X, args.Y, args.Z,
                                Math.Sqrt(args.X * args.X +
                                          args.Y * args.Y +
                                          args.Z * args.Z),
                                args.Timestamp)

        If txtblk.CheckAccess() Then
            SetTextBlockText(txtblk, str)
        Else
            txtblk.Dispatcher.BeginInvoke(New SetTextBlockTextDelegate(AddressOf SetTextBlockText),
                                          txtblk, str)
        End If
    End Sub


    Private Delegate Sub SetTextBlockTextDelegate(ByVal txtblk As TextBlock, ByVal text As String)


    Private Sub SetTextBlockText(ByVal txtblk As TextBlock, ByVal text As String)
        txtblk.Text = text
    End Sub
End Class
